/******************************************************************************
  Project name:
     SG_Blink.c       SmartGLCD Simplest test! ie blink the LED backlight!
     MCU:             P18F8527
     Dev.Board:       SmartGLCD (SmartGLCD 240x128 module)
     Oscillator:      HSPLL 32.0 MHz (8MHz xtal)
     Ext. Modules:    GLCD
     Compiler:        MikroC v7.0 (or MikroC PRO 4.0)

  This is the simplest possible program with a SmartGLCD, it does not
  require the GLCD to be initialised or working, all it does is set the PIC
  pins to outputs to drive the backlight LEDs then flash one of the backlight
  LEDs. This program may be useful to test that the PIC is ok, and the
  bootloader (or programmer) are actually programming the PIC.
******************************************************************************/

#define BacklightRed    PORTC.F2   // PIC pins used to drive the backlight LEDs
#define BacklightGreen  PORTC.F1
#define BacklightBlue   PORTG.F0

//=============================================================================
//  MAIN
//=============================================================================
void main()
{
  //-------------------------------------------------------
  // setup PIC 18F8527 for SmartGLCD pins
  CMCON = 0x07;         // turn off comparators (make all pins digital)
  TRISC = 0b00000000;   // C1, C2 backlight LED
  TRISG = 0b00000000;   // G0 backlight LED

  // GLCD backlight leds; 0=on, 1=off
  BacklightRed    = 1;     // start with all LEDs off
  BacklightGreen  = 1;     
  BacklightBlue   = 1;
  
  //-------------------------------------------------------
  // startup delay, allows time for PSU voltage to settle
  Delay_ms(500);

  //-------------------------------------------------------
  while(1)
  {
    // flash the backlight LED every second
    BacklightGreen = 0;   // led on
    Delay_mS(500);
    BacklightGreen = 1;   // led off
    Delay_mS(500);
  }
}
//-----------------------------------------------------------------------------