/******************************************************************************
    SG_Simple_LCD.c   Very simple GLCD test.
    Copyright:        Open-Source, Jan2011, written by www.RomanBlack.com
    MCU:              P18F8527
    Dev.Board:        SmartGLCD (MikroE SmartGLCD 240x128 module)
    Oscillator:       HSPLL 32.0 MHz (8MHz xtal)
    Compiler:         MikroC v7.0 (or MikroC PRO 4.0)

  This is a very simple test of initialising the GLCD and drawing some
  text and graphic boxes on the screen. It works for either MikroC compiler     
  but you must use the correct .h file and the correct T6963C_init()
  function (see code below).  
******************************************************************************/
// Global Variables
unsigned char i;
unsigned char barlength;

#include "T6963C_MikroC.h"      // include this if using MikroC (older)
//#include "T6963C_MikroC_PRO.h"  // include this if using MikroC PRO


//=============================================================================
//  MAIN
//=============================================================================
void main()
{
  //-------------------------------------------------------
  // setup PIC 18F8527 for SmartGLCD pins
  CMCON = 0x07;        // turn off comparators (make all pins digital)

  LATC =  0b00000110;   // LEDs off at start
  TRISC = 0b00000000;   // C1, C2 backlight LED
  LATG =  0b00000001;   // LED off at start
  TRISG = 0b00000000;   // G0 backlight LED
  
  LATJ  = 0b00000000;   // RJ6=FS (1=font6 0=font8), RJ5=MD
  TRISJ = 0b00000000;   // GLCD control port

  // control the GLCD backlight leds; 0=on, 1=off
  BacklightRed    = 1;     
  BacklightGreen  = 0;    // green is on
  BacklightBlue   = 1;

  //-------------------------------------------------------
  // startup delay, let the PSU voltage stabilise etc.
  Delay_ms(10);

  // Initialize T6963C GLCD
  T6963C_init(240, 128, 8, &PORTH, &PORTJ, 2, 1, 0, 4); // init for MikroC version
  //T6963C_init(240, 128, 8);   // init for MikroC PRO version
  T6963C_graphics(1);       // graphics mode = on
  T6963C_text(1);           // text mode = on (now both are on)
  T6963C_cursor(0);         // cursor = off

  //-------------------------------------------------------
  // test of writing some stuff on the GLCD

  // write single text characters to screen
  // NOTE!! XY coords are for text (display is x=0-29, y=0-15) 
  T6963C_Write_Char('A',2,4,T6963C_ROM_MODE_OR);
  T6963C_Write_Char('B',3,5,T6963C_ROM_MODE_XOR);
  T6963C_Write_Char('C',4,6,T6963C_ROM_MODE_AND);
  T6963C_Write_Char('D',5,7,T6963C_ROM_MODE_TEXT);

  // write a line of text at text X,Y coords of 0,0
  T6963C_Write_Text("Write some simple text here...", 0, 0, T6963C_ROM_MODE_XOR);
 
  // now draw a simple graphics object (an empty rectangle)
  // NOTE!! XY coords are for pixels (display is x=0-239, y=0-127) 
  T6963C_rectangle(0, 80, 239, 80+19, T6963C_WHITE);

  // and fill it with bargraph bars (small filled boxes)
  barlength = 180;
  for(i=2; i<barlength; i+=4)  T6963C_box(i, 82, i+3, 82+15, T6963C_WHITE);

  //-------------------------------------------------------
  while(1)
  {
    // we are done, so just wait here!
  }
}
//-----------------------------------------------------------------------------